<?php

class CreditConfirmationResponseDTO
{

    //Clave compartida para generar la firma. No se envia en ningun momento.
    private $secretKey;

    //Tipo de peticion
    private $requestType;

    //Campos que deben de ir en el JSON
    private $transactionId;
    private $orderId;
    private $result;
    private $resultType;
    private $resultDescription;


    public function __construct()
    {
        $this->secretKey = '';
        $this->transactionId = '';
        $this->orderId = '';
        $this->result = '';
        $this->resultType = '';
        $this->resultDescription = '';
        $this->requestType = ICredit::RECEIVE_CREDIT_CONFIRMATION;
    }

    public function __get($param)
    {
        return $this->$param;
    }

    public function __set($param, $value)
    {
        $this->$param = $value;
    }

    public function toJson()
    {
        return json_encode($this->toArray());
    }

    public function toArray()
    {
        return array(
            'transactionId' => $this->transactionId,
            'orderId' => $this->orderId,
            'result' => $this->result,
            'resultType' => $this->resultType,
            'resultDescription' => $this->resultDescription
        );
    }

    public function CalcularFirma()
    {
        return hash('sha256', utf8_encode($this->secretKey . $this->toJson()));
    }

}