<?php

/**
 * Emplearemos esta clase para encapsular la respuesta
 * Class ResponseDTO
 */
class ResponseDTO
{

    //Clave compartida para generar la firma. No se envia en ningun momento.
    private $secretKey;
    private $response;
    private $responseArray;
    private $signature;
    private $httpResponseCode;
    private $responseOk;
    private $errorMessage;

    /**
     * ResponseDTO constructor.
     */
    function __construct()
    {
        $this->responseRaw = '';
        $this->response = '';
        $this->signature = '';
        $this->httpResponseCode = '';
        $this->httpResponseDescri = '';
        $this->responseOk = true;
        $this->errorMessage = '';
    }

    public function __get($param)
    {
        if ($param == 'responseArray') {
            $responseArray = $this->response != '' ? json_decode($this->response, TRUE) : null;
            if ($responseArray == null) {
                $responseArray = array();
            }

            return $responseArray;
        }

        return $this->$param;
    }

    public function __set($param, $value)
    {
        if ($param != 'responseArray') {
            $this->$param = $value;
        }
    }

    public function toJson()
    {
        return json_encode($this->responseArray);

    }

    public function CalcularFirma()
    {
        return hash('sha256', utf8_encode($this->secretKey . $this->response));
    }

}