<?php
if (!defined('_PS_VERSION_')) {
    exit;
}

if (!class_exists('ICredit')) {
    require_once(dirname(__FILE__) . DIRECTORY_SEPARATOR . 'IcLib' . DIRECTORY_SEPARATOR . 'ICredit.php');
}

class instantcredit extends PaymentModule
{
    protected $_html = '';
    protected $_postErrors = array();

    public $clientId, $userName, $password, $secretKey, $hashToken, $urlAPI, $minFin, $maxFin, $extra_mail_vars, $modoPedido, $entornoPruebas, $simuladorCuotas, $tiendaElectronica;

    public function __construct()
    {
        $this->name = 'instantcredit';
        $this->tab = 'payments_gateways';
        $this->version = '2.0.3';
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => '1.6.99.99');
        $this->author = 'sales@instantcredit.net';
        $this->controllers = array('payment', 'validation', 'confirmation');
        $this->is_eu_compatible = 1;
        $this->currencies = true;
        $this->currencies_mode = 'checkbox';

        $config = Configuration::getMultiple(array('clientId', 'userName', 'password', 'secretKey', 'modoPedido', 'entornoPruebas', 'simuladorCuotas', 'hashToken', 'minFin', 'maxFin', 'tiendaElectronica'));

        if (!empty($config['clientId'])) {
            $this->clientId = $config['clientId'];
        }

        if (!empty($config['userName'])) {
            $this->userName = $config['userName'];
        }
        if (!empty($config['password'])) {
            $this->password = $config['password'];
        }
        if (!empty($config['secretKey'])) {
            $this->secretKey = $config['secretKey'];
        }
        if (!empty($config['hashToken'])) {
            $this->hashToken = $config['hashToken'];
        }
        $this->modoPedido = empty($config['modoPedido']) ? 0 : 1;
        $this->entornoPruebas = !empty($config['entornoPruebas']) ? 1 : 0;;
        $this->simuladorCuotas = $config['simuladorCuotas'];

        if (!empty($config['minFin'])) {
            $this->minFin = $config['minFin'];
        }

        if (!empty($config['maxFin'])) {
            $this->maxFin = $config['maxFin'];
        }

        $this->tiendaElectronica = $config['tiendaElectronica'];

        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = $this->l('Compra ahora y paga después');
        $this->description = $this->l('Proceso rápido y sin papeles con la confianza de Sabadell Consumer');
        $this->confirmUninstall = $this->l('Estas seguro que deseas eliminar este modulo?');
        if (!isset($this->clientId)) {
            $this->warning = $this->l('clientId debe configurarse antes de utilizar el modulo');
        }
        if (!isset($this->userName)) {
            $this->warning = $this->l('userName debe configurarse antes de utilizar el modulo');
        }
        if (!isset($this->password)) {
            $this->warning = $this->l('password debe configurarse antes de utilizar el modulo');
        }
        if (!isset($this->secretKey)) {
            $this->warning = $this->l('secretKey debe configurarse antes de utilizar el modulo');
        }
        if (!isset($this->minFin)) {
            $this->warning = $this->l('Financiación mínima debe configurarse antes de utilizar el modulo');
        }
        if (!isset($this->maxFin)) {
            $this->warning = $this->l('Financiación maxima debe configurarse antes de utilizar el modulo');
        }


        if (!count(Currency::checkPaymentCurrencies($this->id))) {
            $this->warning = $this->l('No hay divisa para este modulo.');
        }

        $this->extra_mail_vars = array(
            '{clientId}' => Configuration::get('clientId'),
            '{userName}' => Configuration::get('userName'),
            '{password}' => Configuration::get('password'),
            '{entornoPruebas}' => Configuration::get('entornoPruebas'),
            '{modoPedido}' => Configuration::get('modoPedido'),
            '{simuladorCuotas}' => Configuration::get('simuladorCuotas'),
            '{tiendaElectronica}' => Configuration::get('tiendaElectronica'),
            '{hashToken}' => Configuration::get('hashToken'),
            '{minFin}' => Configuration::get('minFin'),
            '{maxFin}' => Configuration::get('maxFin'),
            '{secretKey}' => Configuration::get('secretKey')
        );
    }

    public function install()
    {
        Configuration::updateValue('entornoPruebas', true);
        Configuration::updateValue('modoPedido', true);
        Configuration::updateValue('simuladorCuotas', true);
        Configuration::updateValue('tiendaElectronica', false);

        for ($i = 0; $i < count(ICredit::$icEstado); $i++) {
            if (!(Configuration::get(ICredit::$icEstado[$i]))) {
                $this->_insertaEstados(sprintf(ICredit::$textoEstado[$i], $this->name), ICredit::$colorEstado[$i], ICredit::$icEstado[$i], ICredit::$pagadoEstado[$i], ICredit::$emailEstado[$i], ICredit::$templateEstado[$i]);
            }
        }

        if (!$this->_creaTablas()) {
            return false;
        }

        if (!parent::install() || !$this->registerHook('payment') || !$this->registerHook('displayPaymentReturn')  ) {
            return false;
        }

        $this->_copyMailTemplates();

        return true;
    }

    public function uninstall()
    {
        /*
        if (!Configuration::deleteByName('clientId')
                || !Configuration::deleteByName('userName')
                || !Configuration::deleteByName('password')
                || !Configuration::deleteByName('entornoPruebas')
                || !Configuration::deleteByName('simuladorCuotas')
                || !Configuration::deleteByName('tiendaElectronica')
                || !Configuration::deleteByName('hashToken')
                || !Configuration::deleteByName('minFin')
                || !Configuration::deleteByName('maxFin')
                || !Configuration::deleteByName('secretKey')
                || !Configuration::deleteByName('instantcredit_APROBADO')
                || !Configuration::deleteByName('instantcredit_PENDIENTE')
                || !Configuration::deleteByName('instantcredit_DECLINADO')
                || !parent::uninstall())
            return false;
        */


        /*if (!Configuration::deleteByName('instantcredit_APROBADO')
            || !Configuration::deleteByName('instantcredit_PENDIENTE')
            || !Configuration::deleteByName('instantcredit_DECLINADO')
            || !parent::uninstall())
            return false;*/


        if (!parent::uninstall()) {
            return false;
        }

        return true;
    }

    protected function _copyMailTemplates()
    {
        $email_template_name = 'instantcredit_accepted';
        $email_template_source = dirname(__FILE__) . '/mails/' . $email_template_name . '.html';
        $email_template_source_txt = dirname(__FILE__) . '/mails/' . $email_template_name . '.txt';

        $languages = Language::getLanguages(false);
        foreach ($languages as $lang) {
            $email_template_target = _PS_MAIL_DIR_ . '/' . $lang['iso_code'] . '/' . $email_template_name . '.html';
            $email_template_target_txt = _PS_MAIL_DIR_ . '/' . $lang['iso_code'] . '/' . $email_template_name . '.txt';
            copy($email_template_source, $email_template_target);
            copy($email_template_source_txt, $email_template_target_txt);
        }

        $email_template_name = 'instantcredit_cancelled';
        $email_template_source = dirname(__FILE__) . '/mails/' . $email_template_name . '.html';
        $email_template_source_txt = dirname(__FILE__) . '/mails/' . $email_template_name . '.txt';

        $languages = Language::getLanguages(false);
        foreach ($languages as $lang) {
            $email_template_target = _PS_MAIL_DIR_ . '/' . $lang['iso_code'] . '/' . $email_template_name . '.html';
            $email_template_target_txt = _PS_MAIL_DIR_ . '/' . $lang['iso_code'] . '/' . $email_template_name . '.txt';
            copy($email_template_source, $email_template_target);
            copy($email_template_source_txt, $email_template_target_txt);
        }
    }

    protected function _postValidation()
    {
        if (Tools::isSubmit('btnSubmit')) {
            if (!Tools::getValue('clientId')) {
                $this->_postErrors[] = $this->l('clientId are required.');
            } else {
                if ( strpos(Tools::getValue('clientId'),' ') !== false ) {
                    $this->_postErrors[] = $this->l('clientId no puede contener espacios en blanco.');
                }
            }
    
            if (!Tools::getValue('userName')) {
                $this->_postErrors[] = $this->l('userName are required.');
            } else {
                if ( strpos(Tools::getValue('userName'),' ') !== false) {
                    $this->_postErrors[] = $this->l('userName no puede contener espacios en blanco.');
                }
            }
    
            if (!Tools::getValue('password')) {
                $this->_postErrors[] = $this->l('password are required.');
            } else {
                if ( strpos(Tools::getValue('password'),' ') !== false ) {
                    $this->_postErrors[] = $this->l('password no puede contener espacios en blanco.');
                }
            }
    
            if (!Tools::getValue('secretKey')) {
                $this->_postErrors[] = $this->l('secretKey are required.');
            } else {
                if ( strpos(Tools::getValue('secretKey'),' ') !== false ) {
                    $this->_postErrors[] = $this->l('secretKey no puede contener espacios en blanco.');
                }
            }
            if (!Tools::getValue('hashToken')) {
                $this->_postErrors[] = $this->l('hashToken are required.');
            } else {
                if ( strpos(Tools::getValue('hashToken'),' ') !== false ) {
                    $this->_postErrors[] = $this->l('hashToken no puede contener espacios en blanco.');
                }
            }
            if (!Tools::getValue('minFin')) {
                $this->_postErrors[] = $this->l('Financiación mínima are required.');
            } else {
                if ( strpos(Tools::getValue('minFin'),' ') !== false ) {
                    $this->_postErrors[] = $this->l('minFin no puede contener espacios en blanco.');
                }
            }
    
            if (!Tools::getValue('maxFin')) {
                $this->_postErrors[] = $this->l('Financiación maxima are required.');
            } else {
                if ( strpos(Tools::getValue('maxFin'),' ') !== false ) {
                    $this->_postErrors[] = $this->l('maxFin no puede contener espacios en blanco.');
                }
            }
        }
    }

    protected function _postProcess()
    {
        if (Tools::isSubmit('btnSubmit')) {
            Configuration::updateValue('clientId', Tools::getValue('clientId'));
            Configuration::updateValue('userName', Tools::getValue('userName'));
            Configuration::updateValue('password', Tools::getValue('password'));

            if (Tools::getValue('entornoPruebas')) {
                Configuration::updateValue('entornoPruebas', Tools::getValue('entornoPruebas'));
            } else {
                Configuration::deleteByName('entornoPruebas');
            }

            if (Tools::getValue('modoPedido')) {
                Configuration::updateValue('modoPedido', Tools::getValue('modoPedido'));
            } else {
                Configuration::deleteByName('modoPedido');
            }

            if (Tools::getValue('simuladorCuotas')) {
                Configuration::updateValue('simuladorCuotas', Tools::getValue('simuladorCuotas'));
            } else {
                Configuration::deleteByName('simuladorCuotas');
            }

            Configuration::updateValue('hashToken', Tools::getValue('hashToken'));
            Configuration::updateValue('secretKey', Tools::getValue('secretKey'));
            Configuration::updateValue('minFin', Tools::getValue('minFin'));
            Configuration::updateValue('maxFin', Tools::getValue('maxFin'));

            if (Tools::getValue('tiendaElectronica')) {
                Configuration::updateValue('tiendaElectronica', Tools::getValue('tiendaElectronica'));
            } else {
                Configuration::deleteByName('tiendaElectronica');
            }
        }
        $this->_html .= $this->displayConfirmation($this->l('Settings updated'));
    }

    public function getContent()
    {
        if (Tools::isSubmit('btnSubmit')) {
            $this->_postValidation();
            if (!count($this->_postErrors)) {
                $this->_postProcess();
            } else {
                foreach ($this->_postErrors as $err)
                    $this->_html .= $this->displayError($err);
            }
        } else {
            $this->_html .= '<br />';
        }

        $this->_html .= $this->renderForm();

        return $this->_html;
    }
    
    public function getHookController($hook_name)
    {
        require(dirname(__FILE__).'/controllers/front/'.$hook_name.'.php');
        $controller_name = $this->name.$hook_name.'Controller';
        $controller = new $controller_name($this, __FILE__, $this->_path);
        return $controller;
    }

    public function hookPayment($params)
    {
        if (!$this->active) {
            return;
        }

        if (!$this->checkCurrency($params['cart'])) {
            return;
        }

        $cart = $this->context->cart;
        $total = $cart->getOrderTotal(true, Cart::BOTH);

        if ($this->minFin >= $total OR $this->maxFin <= $total) {
            return;
        }
        $cookie = Context::getContext()->cookie;
        if ($cookie->__isset('access_token') ){
            $cookie->__unset('access_token');
        }
        $ICredit = new ICredit();
        $responseDto = new ResponseDTO();
        try {
            $responseDto = $ICredit->GetAccessToken(
                $this->clientId,
                $this->userName,
                $this->password,
                $this->entornoPruebas);
        } catch (Exception $e) {
            $responseDto->responseArray = null;
            $responseDto->httpResponseCode = null;
            $responseDto->responseOk = false;
            $responseDto->errorMessage = $e->getMessage();
            PrestaShopLogger::addLog("ObtenerTokenDeAcceso hookPayment " . date("d/m/y H:i:s") . 'Excpecion: ' . $e->getMessage());
        }

        $this->smarty->assign(array(
            'logo' => Media::getMediaPath(_PS_MODULE_DIR_ . $this->name . '/logo.png'),
            'this_path' => $this->_path,
            'this_path_instantcredit' => $this->_path,
            'this_path_ssl' => Tools::getShopDomainSsl(true, true) . __PS_BASE_URI__ . 'modules/' . $this->name . '/',
            'simuladorCuotas' => $this->simuladorCuotas,
            'hashToken' => $this->hashToken, 
            'entornoPruebas' => $this->entornoPruebas,
            'tiendaElectronica' => $this->tiendaElectronica,
            'urlSimulador' => ICredit::ObtenerURL($this->entornoPruebas, ICredit::SIMULADOR),
            'checkTotal' => $total
        ));

        return $this->display(__FILE__, 'payment.tpl');
    }

    public function hookDisplayPaymentReturn($params)
    {
        $controller = $this->getHookController('displayPaymentReturn');
        return $controller->run($params);
    }   

    public function checkCurrency($cart)
    {
        $currency_order = new Currency($cart->id_currency);
        $currencies_module = $this->getCurrency($cart->id_currency);

        if (is_array($currencies_module)) {
            foreach ($currencies_module as $currency_module)
                if ($currency_order->id == $currency_module['id_currency']) {
                    return true;
                }
        }
        return false;
    }

    public function renderForm()
    {
        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('AJUSTES'),
                    'icon' => 'icon-cogs'
                ),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => 'Modo prueba',
                        'name' => 'entornoPruebas',
                        'is_bool' => true,
                        'hint' => 'Recuerda cambiar los datos de acceso cada vez que cambias el modo ( en caso que los datos son diferentes ).',
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => 'Activado',
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => 'Desactivado',
                            )
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'label' => 'Modo Reserva anticipada del Pedido',
                        'name' => 'modoPedido', 
                        'is_bool' => true,
                        'hint' => 'Con el modo reserva anticipada del pedido, este se generará antes de redireccionar a Sabadell Consumer.',
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => 'Activado',
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => 'Desactivado',
                            )
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'label' => 'Simulador de cuotas',
                        'name' => 'simuladorCuotas',
                        'is_bool' => true,
                        'hint' => 'Mostrar el simulador de cuotas.',
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => 'Activado',
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => 'Desactivado',
                            )
                        ),
                    ),
                    array(
                        'type' => 'switch',
                        'label' => '¿Es una tienda de electrónica?',
                        'name' => 'tiendaElectronica',
                        'is_bool' => true,
                        'hint' => 'Indicamos si nuestra tienda está orientada a aparatos electrónicos',
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => 'Activado',
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => 'Desactivado',
                            )
                        ),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Client Id'),
                        'name' => 'clientId',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('User name'),
                        'name' => 'userName',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Password'),
                        'name' => 'password',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Secret key'),
                        'name' => 'secretKey',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('HASH TOKEN'),
                        'name' => 'hashToken',
                        'required' => false
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Financiación mínima'),
                        'name' => 'minFin',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Financiación maxima'),
                        'name' => 'maxFin',
                        'required' => true
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save', array(), 'Admin.Actions'),
                )
            ),
        );

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $this->fields_form = array();
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->id = (int)Tools::getValue('id_carrier');
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'btnSubmit';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldsValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );

        return $helper->generateForm(array($fields_form));
    }

    public function getConfigFieldsValues()
    {
        return array
        (
            'clientId' => Tools::getValue('clientId', Configuration::get('clientId')),
            'userName' => Tools::getValue('userName', Configuration::get('userName')),
            'password' => Tools::getValue('password', Configuration::get('password')),
            'secretKey' => Tools::getValue('secretKey', Configuration::get('secretKey')),
            'entornoPruebas' => Tools::getValue('entornoPruebas', Configuration::get('entornoPruebas')),
            'modoPedido' => Tools::getValue('modoPedido', Configuration::get('modoPedido')),
            'simuladorCuotas' => Configuration::get('simuladorCuotas'),
            'hashToken' => Tools::getValue('hashToken', Configuration::get('hashToken')),
            'minFin' => Tools::getValue('minFin', Configuration::get('minFin')),
            'maxFin' => Tools::getValue('maxFin', Configuration::get('maxFin')),
            'tiendaElectronica' => Tools::getValue('tiendaElectronica', Configuration::get('tiendaElectronica'))
        );
    }

    protected function _insertaEstados($estado, $color, $osinfo, $paid, $send_email, $template)
    {
        $estado_instantcredit = new OrderState();
        $languages = Language::getLanguages(false);

        foreach ($languages as $lang) {
            $estado_instantcredit->name[(int)$lang['id_lang']] = $this->l($estado);
            $estado_instantcredit->template[(int)$lang['id_lang']] = $template;
        }

        $estado_instantcredit->invoice = $paid;
        $estado_instantcredit->send_email = $send_email;
        $estado_instantcredit->module_name = $this->name;
        $estado_instantcredit->color = $color;
        $estado_instantcredit->unremovable = 1;
        $estado_instantcredit->hidden = 0;
        $estado_instantcredit->logable = $paid;
        $estado_instantcredit->delivery = 0;
        $estado_instantcredit->shipped = 0;
        $estado_instantcredit->paid = $paid;
        $estado_instantcredit->deleted = 0;
        $estado_instantcredit->save();
        Configuration::updateValue($osinfo, $estado_instantcredit->id);

        $origen = dirname(__FILE__) . '/views/img/logo_mini.gif';
        $destino = _PS_CORE_DIR_ . '/img/os/' . (int)$estado_instantcredit->id . '.gif';
        //PrestaShopLogger::addLog("Origen:" . $origen, 1);
        //PrestaShopLogger::addLog("Destino:" . $destino, 1);
        copy($origen, $destino);

    }

    protected function _creaTablas()
    {
        //Guardaremos los datos de la operación.
        $queryOperaciones = "CREATE TABLE IF NOT EXISTS " . _DB_PREFIX_ . "INSTANTCREDIT_TRANSACCIONES (
					          transactionId int NOT NULL PRIMARY KEY ,
                              orderId varchar(100) NOT NULL,
                              custom varchar(100) NOT NULL,
                              result varchar(10) NOT NULL,
                              resultType varchar(50) NOT NULL,
                              resultDescription varchar(100) NOT NULL,
                              country varchar(10) NOT NULL,
                              amount varchar(20) NOT NULL,
                              currency varchar(10) NOT NULL,
                              signature varchar(100) NOT NULL,
                              notificationReceived boolean NOT NULL DEFAULT FALSE)";


        if (!Db::getInstance()->Execute($queryOperaciones)) {
            return false;
        }

        return true;
    }

    public function registrarTransaccion($transactionId, $orderId, $custom, $result, $resultType, $resultDescription, $country, $amount, $currency, $signature)
    {

        try {
            $tableName = "INSTANTCREDIT_TRANSACCIONES";
            $params = array(
                'transactionId' => (int)$transactionId,
                'orderId' => trim($orderId),
                'custom' => trim($custom),
                'result' => trim($result),
                'resultType' => trim($resultType),
                'resultDescription' => trim($resultDescription),
                "country" => trim($country),
                "amount" => trim($amount),
                "currency" => trim($currency),
                "signature" => trim($signature),
                "notificationReceived" => 1);

            return Db::getInstance()->insert($tableName, $params);

        } catch (Exception $ex) {
            PrestaShopLogger::addLog("[InstantCredit] RegistrarTransaccion: [ " . $ex->getMessage() . '] ' . date("d/m/y H:i:s"));
        }

        return false;
    }

    public function obtenerDatosTransaccion($orderId)
    {
        $transaccionDTO = null;
        try {
            $tableName = _DB_PREFIX_ . "INSTANTCREDIT_TRANSACCIONES";
            $consulta = sprintf('SELECT * FROM %s WHERE orderId="%s"', $tableName, trim($orderId));
            $result = Db::getInstance()->ExecuteS($consulta);

            PrestaShopLogger::addLog("Consulta:" . $consulta, 1);

            if (count($result) > 0) {
                $transaccionDTO = new TransaccionDTO();
                $transaccionDTO->transactionId = $result[0]['transactionId'];
                $transaccionDTO->orderId = $result[0]['orderId'];
                $transaccionDTO->custom = $result[0]['custom'];
                $transaccionDTO->result = $result[0]['result'];
                $transaccionDTO->resultType = $result[0]['resultType'];
                $transaccionDTO->resultDescription = $result[0]['resultDescription'];
                $transaccionDTO->country = $result[0]['country'];
                $transaccionDTO->amount = $result[0]['amount'];
                $transaccionDTO->currency = $result[0]['currency'];
                $transaccionDTO->notificationReceived = array_key_exists('notificationReceived', $result[0]) ? $result[0]['notificationReceived'] : false;
            }
        } catch (Exception $ex) {
            PrestaShopLogger::addLog("[InstantCredit] ObtenerDatosTransaccion: [ " . $ex->getMessage() . '] ' . date("d/m/y H:i:s"));
            $transaccionDTO = null;
        }

        return $transaccionDTO;
    }

}
