<?php

require_once('iBase.php');

class  CartElectronicElementDTO implements iBase
{
    private $category;
    private $subCategory;
    private $amount;
    private $currency;
    private $eletronicsDescription;
    private $eletronicsUnits;
    private $eletronicsBrand;
    private $eletronicsDeliveryTimeFreeText;
    private $eletronicsProductCondition;

    function __construct()
    {
        $this->category = '';
        $this->subCategory = '';
        $this->amount = '';
        $this->currency = '';
        $this->eletronicsDescription = '';
        $this->eletronicsUnits = '';
        $this->eletronicsBrand = '';
        $this->eletronicsDeliveryTimeFreeText = '';
        $this->eletronicsProductCondition = '';
    }

    public function __get($param)
    {
        return $this->$param;
    }

    public function __set($param, $value)
    {
        $this->$param = $value;
    }

    public function toJson()
    {       
        return json_encode($this->toArray());
    }

    public function toArray()
    {
        $componentes = array();

        if (!empty($this->category )) {
            $componentes['Category'] = $this->category;
        }


        if (!empty($this->subCategory )) {
            $componentes['SubCategory'] = $this->subCategory;
        }

        if (!empty($this->amount )) {
            $componentes['Amount'] = $this->amount;
        }

        if (!empty($this->currency )) {
            $componentes['Currency'] = $this->currency;
        }

        if (!empty($this->eletronicsDescription )) {
            $componentes['ELETRONICSDescription'] = $this->eletronicsDescription;
        }

        if (!empty($this->eletronicsUnits )) {
            $componentes['ELETRONICSUnits'] = $this->eletronicsUnits;
        }

        if (!empty($this->eletronicsBrand )) {
            $componentes['ELETRONICSBrand'] = $this->eletronicsBrand;
        }

        if (!empty($this->eletronicsDeliveryTimeFreeText )) {
            $componentes['ELETRONICSDeliverytimefreetext'] = $this->eletronicsDeliveryTimeFreeText;
        }

        if (!empty($this->eletronicsProductCondition )) {
            $componentes['ELECTRONICSProductcondition'] = $this->eletronicsProductCondition;
        }
		
		
	 $arrayArrays = array();

        foreach ($componentes as $key => $val) {
            array_push($arrayArrays, array('key' => $key, 'value' => $val));
        }
		
		return $arrayArrays;
    }
}