<?php

require_once('iBase.php');

class  CartElementDTO implements iBase
{
    private $category;
    private $subCategory;
    private $amount;
    private $currency;
    private $otherUnits;
    private $otherDescription;
    private $otherDeliveryTimeFreeText;

    function __construct()
    {
        $this->category = '';
        $this->subCategory = '';
        $this->amount = '';
        $this->currency = '';
        $this->otherUnits = '';
        $this->otherDescription = '';
        $this->otherDeliveryTimeFreeText = '';
    }

    public function __get($param)
    {
        return $this->$param;
    }

    public function __set($param, $value)
    {
        $this->$param = $value;
    }

    public function toJson()
    {
        return json_encode($this->toArray());
    }

    public function toArray()
    {
        $componentes = array();

        if (!empty($this->category)) {
            $componentes['Category'] = $this->category;
        }

        if (!empty($this->subCategory)) {
            $componentes['SubCategory'] = $this->subCategory;
        }

        if (!empty($this->amount)) {
            $componentes['Amount'] = $this->amount;
        }

        if (!empty($this->currency)) {
            $componentes['Currency'] = $this->currency;
        }

        if (!empty($this->otherUnits)) {
            $componentes['OTHERUnits'] = $this->otherUnits;
        }

        if (!empty($this->otherDescription)) {
            $componentes['OTHERDescription'] = $this->otherDescription;
        }
        if (!empty($this->otherDeliveryTimeFreeText)) {
            $componentes['OTHERDeliverytimefreetext'] = $this->otherDeliveryTimeFreeText;
        }

        $arrayArrays = array();

        foreach ($componentes as $key => $val) {
            array_push($arrayArrays, array('key' => $key, 'value' => $val));
        }

        return $arrayArrays;
    }
}