<?php

require_once('iBase.php');
require_once('EndUserDTO.php');
require_once('CartDTO.php');
require_once('InitiatorDTO.php');


class CreditRequestDTO implements iBase
{

    //Clave compartida para generar la firma. No se envia en ningun momento.
    private $secretKey;

    //Tipo de peticion
    private $requestType;

    //Campos que deben de ir en el JSON
    private $orderId;
    private $custom;
    private $amount;
    private $currency;
    private $country;
    private $successURL;
    private $failURL;
    private $notificationURL;
    private $endUser;
    private $cart;
    private $initiator;

    public function __construct()
    {
        $this->secretKey = '';
        $this->orderId = '';
        $this->custom = '';
        $this->amount = '';
        $this->currency = '';
        $this->country = '';
        $this->successURL = '';
        $this->failURL = '';
        $this->notificationURL = '';
        $this->endUser = new EndUserDTO();
        $this->cart = new CartDTO();
        $this->requestType = ICredit::SEND_CREDIT_REQUEST;
        $this->initiator = new InitiatorDTO();
    }

    public function __get($param)
    {
        return $this->$param;
    }

    public function __set($param, $value)
    {
        $this->$param = $value;
    }


    public function toJson()
    {
        return json_encode($this->toArray());
    }

    public function toArray()
    {
        return array(
            'orderId' => $this->orderId,
            'custom' => $this->custom,
            'amount' => $this->amount,
            'currency' => $this->currency,
            'country' => $this->country,
            'successURL' => $this->successURL,
            'failURL' => $this->failURL,
            'notificationURL' => $this->notificationURL,
            'endUser' => $this->endUser != null && is_a($this->endUser, 'EndUserDTO') ? $this->endUser->toArray() : '',
            'cart' => $this->cart != null && is_a($this->cart, 'CartDTO') ? $this->cart->elements : '',
            'initiator' => $this->initiator != null && is_a($this->initiator, 'InitiatorDTO') ? $this->initiator->toArray() : ''
        );
    }

    public function CalcularFirma()
    {
        return hash('sha256', utf8_encode($this->secretKey . $this->toJson()));
    }
}
