<?php
require_once('iBase.php');
require_once('EmploymentStatusEnum.php');
require_once('AddressDTO.php');
require_once('HistoricOrderDTO.php');

class EndUserDTO implements iBase
{
    private $endUserId;
    private $ip;
    private $firstName;
    private $lastName;
    private $personalId;
    private $email;
    private $birthDate;
    private $mobile;
    private $alternativePhoneNumber;
    private $employmentStatus;
    private $address;
    private $billingAddress;
    private $registrationDate;
    private $historicOrders;

    function __construct()
    {
        $this->endUserId = '';
        $this->ip = '';
        $this->firstName = '';
        $this->lastName = '';
        $this->personalId = '';
        $this->email = '';
        $this->birthDate = '';
        $this->mobile = '';
        $this->alternativePhoneNumber = '';
        $this->employmentStatus = EmploymentStatusEnum::DESCONOCIDO;
        $this->address = new AddressDTO();
        $this->billingAddress = new AddressDTO();
        $this->registrationDate = '';
        $this->historicOrders = null;
    }

    public function __get($param)
    {
        return $this->$param;
    }

    public function __set($param, $value)
    {
        $this->$param = $value;
    }

    public function toJson()
    {
        return json_encode($this->toArray());
    }

    public function toArray()
    {

        $componentes = array();

        if (!empty($this->endUserId)) {
            $componentes['endUserId'] = $this->endUserId;
        }

        if (!empty($this->ip)) {
            $componentes['ip'] = $this->ip;
        }

        if (!empty($this->firstName)) {
            $componentes['firstName'] = $this->firstName;
        }

        if (!empty($this->lastName)) {
            $componentes['lastName'] = $this->lastName;
        }

        if (!empty($this->personalId)) {
            $componentes['personalId'] = $this->personalId;
        }

        if (!empty($this->email)) {
            $componentes['email'] = $this->email;
        }

        if (!empty($this->birthDate)) {
            $componentes['birthDate'] = $this->birthDate;
        }

        if (!empty($this->mobile)) {
            $componentes['mobile'] = $this->mobile;
        }

        if (!empty($this->alternativePhoneNumber)) {
            $componentes['alternativePhoneNumber'] = $this->alternativePhoneNumber;
        }

        if (!empty($this->employmentStatus)) {
            $componentes['employmentStatus'] = $this->employmentStatus;
        }

        if ($this->address != null && is_a($this->address, 'AddressDTO')) {
            $componentes['address'] = $this->address->toArray();
        }

        if ($this->billingAddress != null && is_a($this->billingAddress, 'AddressDTO')) {
            $componentes['billingAddress'] = $this->billingAddress->toArray();
        }

        if (!empty($this->registrationDate)) {
            $componentes['registrationDate'] = $this->registrationDate;
        }

        if ($this->historicOrders != null && count($this->historicOrders) > 0) {
            $componentes['historicOrders'] = $this->historicoToArray();
        }

        return $componentes;

        /*return array(
            'endUserId' => $this->endUserId,
            'ip' => $this->ip,
            'firstName' => $this->firstName,
            'lastName' => $this->lastName,
            'personalId' => $this->personalId,
            'email' => $this->email,
            'birthDate' => $this->birthDate,
            'mobile' => $this->mobile,
            'alternativePhoneNumber' => $this->alternativePhoneNumber,
            'employmentStatus' => $this->employmentStatus,
            'address' => $this->address != null && is_a($this->address, 'AddressDTO') ? $this->address->toArray() : '',
            'billingAddress' => $this->billingAddress != null && is_a($this->billingAddress, 'AddressDTO') ? $this->billingAddress->toArray() : '',
            'registrationDate' => $this->registrationDate,
            'historicOrders' => $this->historicoToArray()
        );
        */
    }


    private function historicoToArray()
    {

        $arrayResultante = array();

        if ($this->historicOrders != null && count($this->historicOrders) > 0) {

            foreach ($this->historicOrders as $historicOrder) {

                if (is_a($historicOrder, 'HistoricOrderDTO')) {
                    $arrayResultante[] = $historicOrder->toArray();
                }

            }

        }

        return $arrayResultante;

    }

}