<?php

require_once('iBase.php');
require_once('HistoricOrderStatusEnum.php');

class HistoricOrderDTO implements iBase
{
    private $status;
    private $date;
    private $amount;
    private $currency;
    private $country;

    function __construct()
    {
        $this->status = HistoricOrderStatusEnum::IN_PROCESS;
        $this->date = '';
        $this->amount = '0';
        $this->currency = 'EUR';
        $this->country = 'ES';
    }

    public function __get($param)
    {
        return $this->$param;
    }

    public function __set($param, $value)
    {
        $this->$param = $value;
    }

    public function toJson()
    {
        return json_encode($this->toArray());
    }

    public function toArray()
    {
        $componentes = array();

        if (!empty($this->status )) {
            $componentes['status'] = $this->status;
        }
        if (!empty($this->date )) {
            $componentes['date'] = $this->date;
        }
        if (!empty($this->amount )) {
            $componentes['amount'] = $this->amount;
        }
        if (!empty($this->currency )) {
            $componentes['currency'] = $this->currency;
        }
        if (!empty($this->country )) {
            $componentes['country'] = $this->country;
        }

        return $componentes;

        /*return array(
            'status' => $this->status,
            'date' => $this->date,
            'amount' => $this->amount,
            'currency' => $this->currency,
            'country' => $this->country
        );*/
    }
}