<?php

require_once(dirname(__FILE__) . '/../..' . DIRECTORY_SEPARATOR . 'IcLib' . DIRECTORY_SEPARATOR . 'ICredit.php');
require_once(dirname(__FILE__) . '/../..' . DIRECTORY_SEPARATOR . 'IcLib' . DIRECTORY_SEPARATOR . 'CreditConfirmationResponseDTO.php');
require_once(dirname(__FILE__) . '/../..' . DIRECTORY_SEPARATOR . 'IcLib' . DIRECTORY_SEPARATOR . 'ResultTypeEnum.php');
require_once(dirname(__FILE__) . '/../..' . DIRECTORY_SEPARATOR . 'IcLib' . DIRECTORY_SEPARATOR . 'CartElementDTO.php');
require_once(dirname(__FILE__) . '/../..' . DIRECTORY_SEPARATOR . 'IcLib' . DIRECTORY_SEPARATOR . 'CartElectronicElementDTO.php');


class instantcreditPaymentModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    public $error = true;
    public $message = '';
    public $urlRedirect = "";

    public function initContent()
    {
        $time_start_parent = microtime(true);
        parent::initContent();
        $cart = $this->context->cart;
        /**
        * Verify if this module is enabled and if the cart has
        * a valid customer, delivery address and invoice address
        */
        if (!$this->module->active || $cart->id_customer == 0 || $cart->id_address_delivery == 0
            || $cart->id_address_invoice == 0) {
            Tools::redirect('index.php?controller=order&step=1');
        }
        if ($this->module->modoPedido == ICredit::MODO_PEDIDO_ANTICIPADO_ON) {
            $mailvars = array();
            $orderStatus = ICredit::PENDIENTE;
            $this->module->validateOrder($cart->id, (int)Configuration::get($orderStatus), $cart->getOrderTotal(true), $this->module->displayName, null, $mailvars, null, false, $cart->secure_key, null);
            $orderId = $this->module->currentOrder;
            $order = new Order($orderId);
            $responseDto = $this->RealizarSolicitudDeCredito($order, $cart);

            if ($responseDto == null) {
                $this->message = "Error desconocido al realizar la comunicación con el servidor.";
            } elseif ($responseDto != null && $responseDto->responseOk == false) {
                $this->message = $responseDto->errorMessage;
            } elseif ($responseDto != null && $responseDto->responseOk == true && $responseDto->responseArray == null || count($responseDto->responseArray) == 0) {
                $this->message = "No se he obtenido respuesta del servidor.";
            } else {
                //Si hemos obtenido respuesta, y hemos obtenido elementos de la respuesta, comprobamos las firmas.
                if ($responseDto->responseArray['url'] == 'FAIL') {
                    $this->message = $responseDto->responseArray['resultDescription'];
                } elseif ($responseDto->signature != $responseDto->CalcularFirma()) {
                    $this->message = "Error en la firma recibida.";
                } else {
                    $this->error = false;
                    $this->message = "En unos instantes ser&aacute; redirigido a la pasarela de pago para finalizar el proceso de compra.";
                    $this->title = "Redirigiendo a Instant Credit";
                    $this->urlRedirect = $responseDto->responseArray['url'];
                }
            }
            if ($this->error) {
                $history = new OrderHistory();
                $history->id_order = (int)$orderId;
                $history->changeIdOrderState(6, (int)($orderId));
                $history->save();
                die($this->message);
            }
            Tools::redirect($this->urlRedirect);
        } else {
            $responseDto = $this->RealizarSolicitudDeCreditoOld($cart);

            if ($responseDto == null) {
                $this->message = "Error desconocido al realizar la comunicación con el servidor.";
            } elseif ($responseDto != null && $responseDto->responseOk == false) {
                $this->message = $responseDto->errorMessage;
            } elseif ($responseDto != null && $responseDto->responseOk == true && $responseDto->responseArray == null || count($responseDto->responseArray) == 0) {
                $this->message = "No se he obtenido respuesta del servidor.";
            } else {
                //Si hemos obtenido respuesta, y hemos obtenido elementos de la respuesta, comprobamos las firmas.
                if ($responseDto->responseArray['url'] == 'FAIL') {
                    $this->message = $responseDto->responseArray['resultDescription'];
                } elseif ($responseDto->signature != $responseDto->CalcularFirma()) {
                    $this->message = "Error en la firma recibida.";
                } else {
                    $this->error = false;
                    $this->message = "En unos instantes ser&aacute; redirigido a la pasarela de pago para finalizar el proceso de compra.";
                    $this->title = "Redirigiendo a Instant Credit";
                    $this->urlRedirect = $responseDto->responseArray['url'];
                }
            }

            if ($this->error) {
                die($this->message);
            }
            Tools::redirect($this->urlRedirect);
        }
    }

    public function RealizarSolicitudDeCredito($order, $cart)
    {
        $responseDTO = null;
        try {
            $responseDTO = $this->ObtenerTokenDeAcceso();
            if ($responseDTO->responseOk == true && $responseDTO->responseArray['accessToken'] != null && $responseDTO->responseArray['accessToken'] != '') {
                $responseDTO = ICredit::SendCreditRequest(
                    $this->ObtenerSolicitudDeCredito($order, $cart),
                    $responseDTO->responseArray['accessToken'],
                    $this->module->entornoPruebas
                );
            }
        } catch (Exception $e) {
            PrestaShopLogger::addLog("RealizarSolicitudDeCredito " . date("d/m/y H:i:s") . 'Excpecion: ' . $e->getMessage());
        }


        return $responseDTO;

        //echo $this->ObtenerSolicitudDeCredito($cart)->toJson();

    }

    public function RealizarSolicitudDeCreditoOld($cart)
    {
        $responseDTO = null;
        try {
            $responseDTO = $this->ObtenerTokenDeAcceso();
            if ($responseDTO->responseOk == true && $responseDTO->responseArray['accessToken'] != null && $responseDTO->responseArray['accessToken'] != '') {
                $responseDTO = ICredit::SendCreditRequest(
                    $this->ObtenerSolicitudDeCreditoOld($cart),
                    $responseDTO->responseArray['accessToken'],
                    $this->module->entornoPruebas
                );
            }
        } catch (Exception $e) {
            PrestaShopLogger::addLog("RealizarSolicitudDeCredito " . date("d/m/y H:i:s") . 'Excpecion: ' . $e->getMessage());
        }

        return $responseDTO;
    }

    /**
     * Método para solicitar el tóken de acceso
     * @return ResponseDTO
     */
    public function ObtenerTokenDeAcceso()
    {
        $ICredit = new ICredit();
        $responseDto = new ResponseDTO();

        try {
            $responseDto = $ICredit->GetAccessToken(
                $this->module->clientId,
                $this->module->userName,
                $this->module->password,
                $this->module->entornoPruebas
            );
        } catch (Exception $e) {
            $responseDto->responseArray = null;
            $responseDto->httpResponseCode = null;
            $responseDto->responseOk = false;
            $responseDto->errorMessage = $e->getMessage();
            PrestaShopLogger::addLog("ObtenerTokenDeAcceso " . date("d/m/y H:i:s") . 'Excpecion: ' . $e->getMessage());
        }

        return $responseDto;
    }

    public function ObtenerSolicitudDeCredito($order, $cart)
    {
        $creditRequest = null;

        if ($cart != null) {

            $customer = new Customer((int)($cart->id_customer), (int)$this->context->language->id);
            $orderId = (int)$order->id;
            $direccionEnvio = new Address(intval($cart->id_address_delivery));
            $direccionFacturacion = new Address(intval($cart->id_address_invoice));

            //Seleccionamos la direccion a enviar, si no tenemos direccion de envio, enviamos la direccion de facturación.
            if ($direccionEnvio != null) {
                $direccion = $direccionEnvio;
            } else {
                $direccion = $direccionFacturacion;
            }

            $pais = $direccion->id_country != null ? new Country($direccion->id_country, (int)$this->context->language->id) : null;
            $telefonoAlternativo = null;
            $telefonoMovil = null;

            //Si el telefono de la direccion de envio no es nulo, seleccionamos ese. En caso contrario, el telefono de la direccion de facturación
            if ($direccionEnvio != null) {
                $telefonoAlternativo = $direccionEnvio->phone != null ? trim($direccionEnvio->phone) : null;
                $telefonoMovil = $direccionEnvio->phone_mobile != null ? trim($direccionEnvio->phone_mobile) : null;
            } else {
                $telefonoAlternativo = $direccionFacturacion != null && $direccionFacturacion->phone != null ? trim($direccionFacturacion->phone) : null;
                $telefonoMovil = $direccionFacturacion != null && $direccionFacturacion->phone_mobile != null ? trim($direccionFacturacion->phone_mobile) : null;
            }

            //$baseURL = _PS_BASE_URL_ . __PS_BASE_URI__;
            $baseURL = Tools::getShopProtocol() . $_SERVER['HTTP_HOST'] . __PS_BASE_URI__;

            //Datos de la petición.
            $creditRequest = new CreditRequestDTO();
            $creditRequest->secretKey = $this->module->secretKey;
            $creditRequest->orderId = $orderId;
            $creditRequest->custom = $orderId;
            $creditRequest->amount = '' . $cart->getOrderTotal(true) . '';
            $creditRequest->currency = $this->context->currency->iso_code;
            $creditRequest->country = ($pais != null && $pais->iso_code != null) ? $pais->iso_code : '';
            #$redirectsuccuess = _PS_BASE_URL_ . '/index.php?controller=order-confirmation&id_cart=' . (int) $cart->id . '&id_module=' . (int) $this->module->id . '&id_order=' . (int) $orderId . '&key=' . $cart->secure_key;
            $redirectsuccess = $this->context->link->getPageLink(
                'order-confirmation',
                Configuration::get('PS_SSL_ENABLED'),
                null,
                array(
                    'id_cart' => (int) $cart->id,
                    'id_module' => (int) $this->module->id,
                    'id_order' => (int) $orderId,
                    'key' => $cart->secure_key
                )
            );
            $creditRequest->successURL = $redirectsuccess;
            $creditRequest->failURL = $this->context->link->getModuleLink($this->module->name, 'confirmation', array('fail' => true, "idOrder" => $orderId, "id_cart" => $cart->id), Configuration::get('PS_SSL_ENABLED'));
            $creditRequest->notificationURL = $this->context->link->getModuleLink($this->module->name, 'validation', array(), Configuration::get('PS_SSL_ENABLED'));
            $creditRequest->endUser->endUserId = trim($order->id_customer);
            $creditRequest->endUser->ip = Tools::getRemoteAddr();
            $creditRequest->endUser->firstName = $customer->firstname != null ? trim($customer->firstname) : '';
            $creditRequest->endUser->lastName = $customer->lastname != null ? trim($customer->lastname) : '';
            $creditRequest->endUser->email = $customer->email != null ? trim($customer->email) : '';
            $creditRequest->endUser->birthDate = ($customer->birthday != null && $this->ValidateDate($customer->birthday, $format = 'Y-m-d')) ? trim($customer->birthday) : '';
            $creditRequest->endUser->mobile = $telefonoMovil;
            $creditRequest->endUser->alternativePhoneNumber = $telefonoAlternativo;
            $creditRequest->endUser->employmentStatus = EmploymentStatusEnum::DESCONOCIDO;
            $creditRequest->endUser->registrationDate = $customer->date_add;
            $creditRequest->endUser->address = $this->ObtenerDatosDireccion($direccionEnvio);
            $creditRequest->endUser->billingAddress = $this->ObtenerDatosDireccion($direccionFacturacion);
            $creditRequest->endUser->personalId = $direccionFacturacion->dni != null ? trim($direccionFacturacion->dni) : '';
            $creditRequest->endUser->historicOrders = $this->ObtenerUltimasComprasPorIdCliente(trim($order->id_customer));
            $creditRequest->cart = $this->ObtenerCarritoDeLaCompra($cart);
            $creditRequest->initiator->brand = 'prestashop';
            $creditRequest->initiator->type = 'module';
            $version_parts = explode('.', _PS_VERSION_);
            $versionToSend = 'v' . $version_parts[0] . '.' . $version_parts[1];
            $creditRequest->initiator->extraInformation = $versionToSend;
        }

        return $creditRequest;
    }

    public function ObtenerSolicitudDeCreditoOld($cart)
    {
        $creditRequest = null;

        if ($cart != null) {

            $customer = new Customer((int)($cart->id_customer), (int)$this->context->language->id);
            $orderId = str_pad($cart->id, 8, "0", STR_PAD_LEFT) . "_" . date('His');
            $direccionEnvio = new Address(intval($cart->id_address_delivery));
            $direccionFacturacion = new Address(intval($cart->id_address_invoice));

            //Seleccionamos la direccion a enviar, si no tenemos direccion de envio, enviamos la direccion de facturación.
            if ($direccionEnvio != null) {
                $direccion = $direccionEnvio;
            } else {
                $direccion = $direccionFacturacion;
            }

            $pais = $direccion->id_country != null ? new Country($direccion->id_country, (int)$this->context->language->id) : null;
            $telefonoAlternativo = null;
            $telefonoMovil = null;

            //Si el telefono de la direccion de envio no es nulo, seleccionamos ese. En caso contrario, el telefono de la direccion de facturación
            if ($direccionEnvio != null) {
                $telefonoAlternativo = $direccionEnvio->phone != null ? trim($direccionEnvio->phone) : null;
                $telefonoMovil = $direccionEnvio->phone_mobile != null ? trim($direccionEnvio->phone_mobile) : null;
            } else {
                $telefonoAlternativo = $direccionFacturacion != null && $direccionFacturacion->phone != null ? trim($direccionFacturacion->phone) : null;
                $telefonoMovil = $direccionFacturacion != null && $direccionFacturacion->phone_mobile != null ? trim($direccionFacturacion->phone_mobile) : null;
            }

            //$baseURL = _PS_BASE_URL_ . __PS_BASE_URI__;
            $baseURL = Tools::getShopProtocol() . $_SERVER['HTTP_HOST'] . __PS_BASE_URI__;

            //Datos de la petición.
            $creditRequest = new CreditRequestDTO();
            $creditRequest->secretKey = $this->module->secretKey;
            $creditRequest->orderId = $orderId;
            $creditRequest->custom = $orderId;
            $creditRequest->amount = '' . $cart->getOrderTotal(true) . '';
            $creditRequest->currency = $this->context->currency->iso_code;
            $creditRequest->country = ($pais != null && $pais->iso_code != null) ? $pais->iso_code : '';
            # $redirectsuccuess = _PS_BASE_URL_ . '/index.php?controller=order-confirmation&id_cart=' . (int) $cart->id . '&id_module=' . (int) $this->module->id . '&id_order=' . (int) $orderId . '&key=' . $cart->secure_key;
            $redirectsuccess = $this->context->link->getPageLink(
                'order-confirmation',
                Configuration::get('PS_SSL_ENABLED'),
                null,
                array(
                    'id_cart' => (int) $cart->id,
                    'id_module' => (int) $this->module->id,
                    'id_order' => (int) $orderId,
                    'key' => $cart->secure_key
                )
            );
            $creditRequest->successURL = $redirectsuccess;
            $creditRequest->failURL = $this->context->link->getModuleLink($this->module->name, 'confirmation', array('fail' => true, "idOrder" => $orderId, "id_cart" => $cart->id), Configuration::get('PS_SSL_ENABLED'));
            $creditRequest->notificationURL = $this->context->link->getModuleLink($this->module->name, 'validation', array(), Configuration::get('PS_SSL_ENABLED'));
            $creditRequest->endUser->endUserId = trim($cart->id_customer);
            $creditRequest->endUser->ip = Tools::getRemoteAddr();
            $creditRequest->endUser->firstName = $customer->firstname != null ? trim($customer->firstname) : '';
            $creditRequest->endUser->lastName = $customer->lastname != null ? trim($customer->lastname) : '';
            $creditRequest->endUser->email = $customer->email != null ? trim($customer->email) : '';
            $creditRequest->endUser->birthDate = ($customer->birthday != null && $this->ValidateDate($customer->birthday, $format = 'Y-m-d')) ? trim($customer->birthday) : '';
            $creditRequest->endUser->mobile = $telefonoMovil;
            $creditRequest->endUser->alternativePhoneNumber = $telefonoAlternativo;
            $creditRequest->endUser->employmentStatus = EmploymentStatusEnum::DESCONOCIDO;
            $creditRequest->endUser->registrationDate = $customer->date_add;
            ;
            $creditRequest->endUser->address = $this->ObtenerDatosDireccion($direccionEnvio);
            $creditRequest->endUser->billingAddress = $this->ObtenerDatosDireccion($direccionFacturacion);
            $creditRequest->endUser->personalId = $direccionFacturacion->dni != null ? trim($direccionFacturacion->dni) : '';
            $creditRequest->endUser->historicOrders = $this->ObtenerUltimasComprasPorIdCliente(trim($cart->id_customer));
            $creditRequest->cart = $this->ObtenerCarritoDeLaCompra($cart);
            $creditRequest->initiator->brand = 'prestashop';
            $creditRequest->initiator->type = 'module';
            $version_parts = explode('.', _PS_VERSION_);
            $versionToSend = 'v' . $version_parts[0] . '.' . $version_parts[1];
            $creditRequest->initiator->extraInformation = $versionToSend;
        }

        return $creditRequest;
    }

    private function ObtenerDatosDireccion($direccionPrestashop)
    {
        $direccion = null;
        if ($direccionPrestashop != null) {
            $pais = $direccionPrestashop->id_country != null ? new Country($direccionPrestashop->id_country, (int)$this->context->language->id) : null;
            $direccion = new AddressDTO();
            $direccion->street = ($direccionPrestashop->address1 != null) ? str_replace(PHP_EOL, ' ', trim($direccionPrestashop->address1)) : '';
            $direccion->street .= ($direccionPrestashop->address2 != null) ? ' ' . str_replace(PHP_EOL, ' ', trim($direccionPrestashop->address2)) : '';
            $direccion->postalCode = ($direccionPrestashop->postcode != null) ? $direccionPrestashop->postcode : '';
            $direccion->province = ($direccionPrestashop->postcode != null) ? substr($direccionPrestashop->postcode, 0, 2) : '';
            $direccion->city = ($direccionPrestashop->city != null) ? $direccionPrestashop->city : '';
            $direccion->country = ($pais != null && $pais->iso_code != null) ? $pais->iso_code : '';
        }
        return $direccion;
    }

    /***
     * Método para obtener la información de las ultimas compras del cliente.
     * @param $customerId
     * @return array
     */
    private function ObtenerUltimasComprasPorIdCliente($customerId)
    {
        $historicOrders = null;

        try {
            $orders = Order::getCustomerOrders($customerId);

            //Si solo tiene una compra es la que estamos haciendo, así que la ignoramos.
            if (count($orders) >= 1) {
                $historicOrders = array();
                $orderoutofdate = false;
                $totalvalidorders = 0;
                foreach ($orders as $index => $order) {
                    $myOrder = new Order((int)$order['id_order'], (int)$this->context->language->id);
                    $moneda = new Currency((int)$myOrder->id_currency, (int)$this->context->language->id);
                    $direccionFacturacion = new Address(intval($myOrder->id_address_invoice));
                    $pais = $direccionFacturacion->id_country != null ? new Country($direccionFacturacion->id_country) : null;
                    $estadoDelPedido = $myOrder->getCurrentOrderState();

                    //Agregamos a la lista solo los pedidos cuyo estádo sea pagado, enviado o entregado.
                    if ($estadoDelPedido->paid || $estadoDelPedido->shipped || $estadoDelPedido->delivery) {
                        $historico = new HistoricOrderDTO();
                        $historico->status = $this->ObtenerEstadoInstantCredit($estadoDelPedido);
                        $historico->date = trim($myOrder->date_add);
                        $time = strtotime($myOrder->date_add);
                        if ($time < time() - strtotime('-12 months')) {
                            $orderoutofdate = true;
                        }
                        $historico->amount = trim($myOrder->getTotalPaid());
                        $historico->currency = trim($moneda->iso_code);
                        $historico->country = ($pais != null && $pais->iso_code != null) ? $pais->iso_code : '';
                        $historicOrders[] = $historico;
                        $totalvalidorders = $totalvalidorders + 1;
                    }
                    if ($orderoutofdate || ($totalvalidorders == 9)) {
                        break;
                    }
                }
            }
        } catch (Exception $e) {
            PrestaShopLogger::addLog("ObtenerUltimasComprasPorIdCliente " . date("d/m/y H:i:s") . 'Excpecion: ' . $e->getMessage());
        }

        return $historicOrders;
    }

    private function ObtenerCarritoDeLaCompra($cartPrestashop)
    {
        $cart = new CartDTO();
        $carrier = new Carrier((int)$cartPrestashop->id_carrier, (int)$this->context->language->id);
        $shippingCost = $cartPrestashop->getPackageShippingCost((int)$cartPrestashop->id_carrier);
        $items = $cartPrestashop->getProducts();

        foreach ($items as $item) {
            $product = new Product($item['id_product'], (int)$this->context->language->id);
            $all_product_subs = Product::getProductCategoriesFull((int)$product->id, (int)$this->context->language->id);
            $categoria = null;
            $subcategoria = null;


            if (isset($all_product_subs) && count($all_product_subs) > 0) {
                $alterna = true;
                foreach ($all_product_subs as $subcat) {
                    if ($alterna == true) {
                        $categoria = trim($subcat["name"]);
                        $alterna = false;
                    } else {
                        $subcategoria = trim($subcat["name"]);
                        $alterna = true;
                    }
                }
            }

            $cartElement = null;

            if (!empty(Configuration::get('tiendaElectronica'))) {
                $cartElement = new CartElectronicElementDTO();
                $cartElement->category = "ELECTRONICS";
                $cartElement->subCategory = sprintf("%s{{DOT}}%s", $categoria, $subcategoria);
                $cartElement->amount = number_format($price = Product::getPriceStatic($item['id_product']), 2, '.', '');
                $cartElement->currency = $this->context->currency->iso_code;
                $cartElement->eletronicsDescription = $product->name[(int)$this->context->language->id];
                $cartElement->eletronicsUnits = $item['cart_quantity'];
                $cartElement->eletronicsBrand = $product->manufacturer_name;
                $cartElement->eletronicsProductCondition = "";

                if ($product->condition == "new") {
                    $cartElement->eletronicsProductCondition = "New";
                } elseif ($product->condition == "used" || $product->condition == "refurbished") {
                    $cartElement->eletronicsProductCondition = "Used";
                }

            } else {
                $cartElement = new CartElementDTO();
                $cartElement->category = "OTHER";
                $cartElement->subCategory = sprintf("%s{{DOT}}%s", $categoria, $subcategoria);
                $cartElement->amount = number_format($price = Product::getPriceStatic($item['id_product']), 2, '.', '');
                $cartElement->currency = $this->context->currency->iso_code;
                $cartElement->otherUnits = $item['cart_quantity'];
                $cartElement->otherDescription = $product->name[(int)$this->context->language->id];
            }

            if ($cartElement != null) {
                $cart->addToCart($cartElement);
            }
        }

        //Gastos de envío independientes de los productos.
        if ($carrier != null) {
            $cartElement = new CartElementDTO();
            $cartElement->category = "OTHER";
            $cartElement->amount = !empty($shippingCost) ? $shippingCost : 0;
            $cartElement->currency = $this->context->currency->iso_code;
            $cartElement->otherUnits = 1;
            $cartElement->otherDeliveryTimeFreeText = $carrier->name;
            $cart->addToCart($cartElement);
        }

        return $cart;
    }

    private function ObtenerEstadoInstantCredit($statusPrestashop)
    {

        $statusname = '';
        $estado = HistoricOrderStatusEnum::IN_PROCESS;

        if ($statusPrestashop != null) {

            if ($statusPrestashop->shipped || $statusPrestashop->delivery) {
                $estado = HistoricOrderStatusEnum::AUTHORIZED;
            } elseif ($statusPrestashop->paid) {
                if (is_array($statusPrestashop->name)) {
                    $statusname = current($statusPrestashop->name);
                } else {
                    $statusname = $statusPrestashop->name;
                }
                switch (trim($statusname)) {
                    case'Pago mediante cheque pendiente':
                    case'Awaiting check payment':
                    case'Preparación en proceso':
                    case'Processing in progress':
                    case'Pago por transferencia bancaria pendiente':
                    case'Awaiting bank wire payment':
                    case'Pago mediante PayPal pendiente':
                    case'Awaiting PayPal payment':
                    case'Awaiting Cash On Delivery validation':
                        $estado = HistoricOrderStatusEnum::IN_PROCESS;
                        break;
                    default:
                        $estado = HistoricOrderStatusEnum::IN_PROCESS;
                        break;
                }
            }
        }
        return $estado;
    }

    private function ValidateDate($date, $format = 'Y-m-d H:i:s')
    {
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }

}
