<?php

require_once(dirname(__FILE__) . '/../..' . DIRECTORY_SEPARATOR . 'IcLib' . DIRECTORY_SEPARATOR . 'ICredit.php');
require_once(dirname(__FILE__) . '/../..' . DIRECTORY_SEPARATOR . 'IcLib' . DIRECTORY_SEPARATOR . 'CreditConfirmationResponseDTO.php');
require_once(dirname(__FILE__) . '/../..' . DIRECTORY_SEPARATOR . 'IcLib' . DIRECTORY_SEPARATOR . 'ResultTypeEnum.php');

class instantcreditValidationModuleFrontController extends ModuleFrontController
{

    public function postProcess()
    {
        try {

            $response = file_get_contents("php://input");
            //$cabeceras = getallheaders();
            
                $cabeceras = [];
                foreach ($_SERVER as $name => $value) {
                    if (substr($name, 0, 5) == 'HTTP_') {
                        $cabeceras[str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))))] = $value;
                    }
                }  
                
            $responseDto = ICredit::ProcesaRespuesta($response, $cabeceras, $this->module->secretKey);
            PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] callbackAction ResponseDTO Response: [" . $responseDto->response . ']  Signature: [' . $responseDto->signature . '] ' . date("d/m/y H:i:s"));

            if ($responseDto->responseArray == null || count($responseDto->responseArray) == 0 || $responseDto->signature == null || $responseDto->signature === '') {
                $comment = 'No se han recibido parámetros de respuesta';
                die($comment);

            } elseif (count($responseDto->responseArray) > 0) {
                if ($this->module->modoPedido == ICredit::MODO_PEDIDO_ANTICIPADO_ON) {
                    $orderId = $responseDto->responseArray['orderId'];
                    PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] callbackAction OrderID: [" . $orderId . "] " . date("d/m/y H:i:s"));

                    $history = new OrderHistory();
                    $history->id_order = (int)$orderId;
                    $accept_state = Configuration::get('instantcredit_APROBADO');
                    $declined_state = Configuration::get('instantcredit_CANCELADO');
                    $mailvars = array();

                    $creditConfirmationResponse = new CreditConfirmationResponseDTO();
                    $creditConfirmationResponse->secretKey = $this->module->secretKey;
                    $creditConfirmationResponse->transactionId = $responseDto->responseArray['transactionId'];
                    $creditConfirmationResponse->orderId = $responseDto->responseArray['orderId'];
                    $creditConfirmationResponse->result = 'FAIL';

                    if ($responseDto->CalcularFirma() != $responseDto->signature) {
                        PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] Callback Error en la firma recibida " . date("d/m/y H:i:s"));
                        $creditConfirmationResponse->resultType = ResultTypeEnum::UNDEFINED;
                        $creditConfirmationResponse->resultDescription = '';
                        $comment = utf8_encode('Se ha producido un error en la firma recibida');
                        $orderStatus = ICredit::DECLINADO;
                        $history->changeIdOrderState(6, (int)($orderId));
                        $history->save();
                    } else {
                        PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] Callback Firma recibida OK " . date("d/m/y H:i:s"));
                        $creditConfirmationResponse->resultType = $responseDto->responseArray['resultType'];
                        $creditConfirmationResponse->resultDescription = 'Acknowledgement';
                        $comment = self::ObtenerComentarioPorResultadoDeLaTransaccion($orderId, $responseDto->responseArray['resultType']);
                        $orderStatus = self::ObtenerEstadoPorResultadoDeLaTransaccion($responseDto->responseArray['resultType']);
                        $creditConfirmationResponse->result = 'OK';
                    }

                    $transaccionDTO = $this->module->obtenerDatosTransaccion($orderId);

                    PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] obtenerDatosTransaccion OK " . date("d/m/y H:i:s"));

                    if ($transaccionDTO == null) {
                        if ($orderStatus == ICredit::APROBADO) {
                            $history->changeIdOrderState(2, (int)($orderId));
                            $history->save();
                            $this->sendEmailToUser($orderId, $comment, 'instantcredit_accepted');

                            $this->module->registrarTransaccion(
                                $responseDto->responseArray['transactionId'],
                                $orderId,
                                $responseDto->responseArray['custom'],
                                $responseDto->responseArray['result'],
                                $responseDto->responseArray['resultType'],
                                $responseDto->responseArray['resultDescription'],
                                $responseDto->responseArray['country'],
                                $responseDto->responseArray['amount'],
                                $responseDto->responseArray['currency'],
                                $responseDto->signature);
                        } else{
                            if ($orderStatus == ICredit::CANCELLED_BY_END_USER){
                                $declined_state = Configuration::get('instantcredit_CANCELLED_BY_END_USER');
                            }
                            $history->changeIdOrderState(6, (int)($orderId));
                            $history->save();
  
                            $order = new Order($orderId);
                            $customer_thread = new CustomerThread();
                            $customer_thread->id_contact = 0;
                            $customer_thread->id_customer = (int) $order->id_customer;
                            $customer_thread->id_shop = (int) $this->context->shop->id;
                            $customer_thread->id_order = (int) $order->id;
                            $customer_thread->id_lang = (int) $this->context->language->id;
                            $customer_thread->email = '';
                            $customer_thread->status = 'open';
                            $customer_thread->token = Tools::passwdGen(12);
                            $customer_thread->add();
                            $customer_message = new CustomerMessage();
                            $customer_message->id_customer_thread = $customer_thread->id;
                            $customer_message->id_employee = 0;
                            $customer_message->message = self::ObtenerComentarioPorResultadoDeLaTransaccion($orderId, $responseDto->responseArray['resultType']);
                            $customer_message->private = true;
                            $customer_message->add();
                            $this->module->registrarTransaccion(
                                $responseDto->responseArray['transactionId'],
                                $orderId,
                                $responseDto->responseArray['custom'],
                                $responseDto->responseArray['result'],
                                $responseDto->responseArray['resultType'],
                                $responseDto->responseArray['resultDescription'],
                                $responseDto->responseArray['country'],
                                $responseDto->responseArray['amount'],
                                $responseDto->responseArray['currency'],
                                $responseDto->signature);
                        }

                    } else {
                        PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] Callback - La Operacion " . $orderId . 'ya había sido registrada en el sistema ' . date("d/m/y H:i:s"));
                    }
                } else {
                    $orderId = $responseDto->responseArray['orderId'];
                    $cartId = Tools::substr($orderId, 0, 8);
                    $cart = new Cart($cartId);
                    $mailvars = array();

                    $creditConfirmationResponse = new CreditConfirmationResponseDTO();
                    $creditConfirmationResponse->secretKey = $this->module->secretKey;
                    $creditConfirmationResponse->transactionId = $responseDto->responseArray['transactionId'];
                    $creditConfirmationResponse->orderId = $responseDto->responseArray['orderId'];
                    $creditConfirmationResponse->result = 'FAIL';
                    if ($responseDto->CalcularFirma() != $responseDto->signature) {
                        PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] Callback Error en la firma recibida " . date("d/m/y H:i:s"));
                        $creditConfirmationResponse->resultType = ResultTypeEnum::UNDEFINED;
                        $creditConfirmationResponse->resultDescription = '';
                        $comment = utf8_encode('Se ha producido un error en la firma recibida');
                        $orderStatus = ICredit::DECLINADO;
                    } else {
                        PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] Callback Firma recibida OK " . date("d/m/y H:i:s"));
                        $creditConfirmationResponse->resultType = $responseDto->responseArray['resultType'];
                        $creditConfirmationResponse->resultDescription = 'Acknowledgement';
                        $comment = self::ObtenerComentarioPorResultadoDeLaTransaccion($orderId, $responseDto->responseArray['resultType']);
                        $orderStatus = self::ObtenerEstadoPorResultadoDeLaTransaccion($responseDto->responseArray['resultType']);
                        $creditConfirmationResponse->result = 'OK';
                    }
    
                    $transaccionDTO = $this->module->obtenerDatosTransaccion($orderId);
                    PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] obtenerDatosTransaccion OK " . date("d/m/y H:i:s"));
                    if ($transaccionDTO == null) {
                        if ($orderStatus == ICredit::APROBADO) {
                            PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] Status APROBADO " . date("d/m/y H:i:s"));
    
                            $this->module->validateOrder($cart->id, 2, $cart->getOrderTotal(true), $this->module->displayName, null, $mailvars, null, false, $cart->secure_key, null);
                            PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] validateOrder OK " . date("d/m/y H:i:s"));
                            $orderId = $this->module->currentOrder;

                            $this->sendEmailToUser($orderId, $comment, 'instantcredit_accepted');
                            PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] sendEmailToUser OK " . date("d/m/y H:i:s"));
    
                            $this->module->registrarTransaccion(
                                $responseDto->responseArray['transactionId'],
                                $orderId,
                                $responseDto->responseArray['custom'],
                                $responseDto->responseArray['result'],
                                $responseDto->responseArray['resultType'],
                                $responseDto->responseArray['resultDescription'],
                                $responseDto->responseArray['country'],
                                $responseDto->responseArray['amount'],
                                $responseDto->responseArray['currency'],
                                $responseDto->signature);
                            PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] registrarTransaccion OK " . date("d/m/y H:i:s"));
                        } else {
                            $this->module->registrarTransaccion(
                                $responseDto->responseArray['transactionId'],
                                $orderId,
                                $responseDto->responseArray['custom'],
                                $responseDto->responseArray['result'],
                                $responseDto->responseArray['resultType'],
                                $responseDto->responseArray['resultDescription'],
                                $responseDto->responseArray['country'],
                                $responseDto->responseArray['amount'],
                                $responseDto->responseArray['currency'],
                                $responseDto->signature);
                        }
                    } else {
                        PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] Callback - La Operacion " . $orderId . 'ya había sido registrada en el sistema ' . date("d/m/y H:i:s"));
                    }
                }
                header_remove();
                header("content-type: application/json;");
                header("Signature: " . $creditConfirmationResponse->CalcularFirma());
                die($creditConfirmationResponse->toJson());

            }
        } catch (Exception $ex) {
            PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] Callback Excepcion Global: [ " . $ex->getMessage() . '] ' . date("d/m/y H:i:s"));
        }
    }


    private static function ObtenerEstadoPorResultadoDeLaTransaccion($resultType)
    {
        switch (strtoupper($resultType)) {
            case ResultTypeEnum::SUCCESSFUL:
                $state = ICredit::APROBADO;
                break;
            case ResultTypeEnum::TIMEOUT:
                $state = ICredit::TIMEOUT;
                break;
            case ResultTypeEnum::CANCELLED_BY_ENDUSER:
                $state = ICredit::CANCELLED_BY_END_USER;
                break;
            case ResultTypeEnum::INCORRECT_DATE:
            case ResultTypeEnum::ORDER_ID_ALREADY_EXISTS:
            case ResultTypeEnum::NO_LENDERS_AVAILABLE:
            case ResultTypeEnum::INCORRECT_CURRENCY:
            case ResultTypeEnum::INCORRECT_COUNTRY:
            case ResultTypeEnum::UNDEFINED:
            default:
                $state = ICredit::DECLINADO;
                break;
        }

        PrestaShopLogger::addLog("[ObtenerEstadoPorResultadoDeLaTransaccion] state [" . $state . "]" . date("d/m/y H:i:s"));

        return $state;
    }

    private static function ObtenerComentarioPorResultadoDeLaTransaccion($orderId, $resultType)
    {
        $comment = '';

        switch (strtoupper($resultType)) {
            case ResultTypeEnum::SUCCESSFUL:
                $comment = 'Financiación autorizada para el pedido ' . $orderId;
                break;
            case ResultTypeEnum::TIMEOUT:
                $comment = 'Financiación denegada para el pedido ' . $orderId . ' - TIMEOUT';
                break;
            case ResultTypeEnum::CANCELLED_BY_ENDUSER:
                $comment = 'Financiación denegada para el pedido ' . $orderId . ' - Financiacion cancelada por el usuario';
                break;
            case ResultTypeEnum::INCORRECT_DATE:
                $comment = $comment != '' ? $comment : 'Financiación denegada para el pedido ' . $orderId . ' - Fecha incorrecta';
            case ResultTypeEnum::ORDER_ID_ALREADY_EXISTS:
                $comment = $comment != '' ? $comment : 'Financiación denegada para el pedido ' . $orderId . ' - Ya existe una orden con este identificador';
            case ResultTypeEnum::NO_LENDERS_AVAILABLE:
                $comment = $comment != '' ? $comment : 'Financiación denegada para el pedido ' . $orderId;
            case ResultTypeEnum::INCORRECT_CURRENCY:
                $comment = $comment != '' ? $comment : 'Financiación denegada para el pedido ' . $orderId . ' - Moneda incorrecta';
            case ResultTypeEnum::INCORRECT_COUNTRY:
                $comment = $comment != '' ? $comment : 'Financiación denegada para el pedido ' . $orderId . ' - Pais icorrecto';
            case ResultTypeEnum::UNDEFINED:
                $comment = $comment != '' ? $comment : 'Financiación denegada para el pedido ' . $orderId . ' - Motivo desconocido';
            default:
                $comment = $comment != '' ? $comment : 'Financiación denegada para el pedido ' . $orderId;
                break;
        }
        PrestaShopLogger::addLog("[ObtenerEstadoPorResultadoDeLaTransaccion] comment [" . $comment . "]" . date("d/m/y H:i:s"));
        return $comment;
    }
    private function getFormatedAddress(Address $the_address, $line_sep, $fields_style = array())
    {
        return AddressFormat::generateAddress($the_address, array('avoid' => array()), $line_sep, ' ', $fields_style);
    }
    private function getEmailTemplateContent($template_name, $mail_type, $var)
    {
        $email_configuration = Configuration::get('PS_MAIL_TYPE');
        if ($email_configuration != $mail_type && $email_configuration != Mail::TYPE_BOTH) {
            return '';
        }

        $pathToFindEmail = array(
            _PS_THEME_DIR_ . 'mails' . DIRECTORY_SEPARATOR . $this->context->language->iso_code . DIRECTORY_SEPARATOR . $template_name,
            _PS_THEME_DIR_ . 'mails' . DIRECTORY_SEPARATOR . 'en' . DIRECTORY_SEPARATOR . $template_name,
            _PS_MAIL_DIR_ . $this->context->language->iso_code . DIRECTORY_SEPARATOR . $template_name,
            _PS_MAIL_DIR_ . 'en' . DIRECTORY_SEPARATOR . $template_name,
        );

        foreach ($pathToFindEmail as $path) {
            if (Tools::file_exists_cache($path)) {
                $this->context->smarty->assign('list', $var);

                return $this->context->smarty->fetch($path);
            }
        }

        return '';
    }
    private function sendEmailToUser($orderId, $email_subject, $email_template)
    {
        try {
            PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] sendEmailToUser - orderId:[ " . $orderId . '] $email_subject: [' . $email_subject . ']' . date("d/m/y H:i:s"));
            $order = new Order($orderId);
            $invoice = new Address((int) $order->id_address_invoice);
            $delivery = new Address((int) $order->id_address_delivery);
            $delivery_state = $delivery->id_state ? new State((int) $delivery->id_state) : false;
            $invoice_state = $invoice->id_state ? new State((int) $invoice->id_state) : false;
            $customer = new Customer ($order->id_customer);
            $carrier = new Carrier( (int) $order->id_carrier);
            $currency = new Currency($order->id_currency);
            // Construct order detail table for the email
            $products_list = '';
            $virtual_product = true;

            $product_var_tpl_list = array();
            foreach ($order->getCartProducts() as $product) {
                $price = Product::getPriceStatic((int) $product['id_product'], false, ($product['id_product_attribute'] ? (int) $product['id_product_attribute'] : null), 6, null, false, true, $product['cart_quantity'], false, (int) $order->id_customer, (int) $order->id_cart, (int) $order->{Configuration::get('PS_TAX_ADDRESS_TYPE')}, $specific_price, true, true, null, true, $product['id_customization']);
                $price_wt = Product::getPriceStatic((int) $product['id_product'], true, ($product['id_product_attribute'] ? (int) $product['id_product_attribute'] : null), 2, null, false, true, $product['cart_quantity'], false, (int) $order->id_customer, (int) $order->id_cart, (int) $order->{Configuration::get('PS_TAX_ADDRESS_TYPE')}, $specific_price, true, true, null, true, $product['id_customization']);

                $product_price = Product::getTaxCalculationMethod() == PS_TAX_EXC ? Tools::ps_round($price, 2) : $price_wt;
                PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] sendEmailToUser - product:[ " . json_encode($product) . '] $email_subject: [' . $email_subject . ']' . date("d/m/y H:i:s"));

                $product_var_tpl = array(
                    'id_product' => $product['id_product'],
                    'reference' => $product['reference'],
                    'name' => $product['product_name'] . (isset($product['attributes']) ? ' - ' . $product['attributes'] : ''),
                    'price' => Tools::displayPrice($product_price * $product['product_quantity'], $this->context->currency, false),
                    'quantity' => $product['product_quantity'],
                    'customization' => array(),
                );

                if (isset($product['product_price']) && $product['product_price']) {
                    $product_var_tpl['unit_price'] = Tools::displayPrice($product_price, $this->context->currency, false);
                    $product_var_tpl['unit_price_full'] = Tools::displayPrice($product_price, $this->context->currency, false)
                                . ' ' . $product['unity'];
                } else {
                    $product_var_tpl['unit_price'] = $product_var_tpl['unit_price_full'] = '';
                }

                $customized_datas = Product::getAllCustomizedDatas((int) $order->id_cart, null, true, null, (int) $product['id_customization']);
                if (isset($customized_datas[$product['id_product']][$product['id_product_attribute']])) {
                    $product_var_tpl['customization'] = array();
                    foreach ($customized_datas[$product['id_product']][$product['id_product_attribute']][$order->id_address_delivery] as $customization) {
                        $customization_text = '';
                        if (isset($customization['datas'][Product::CUSTOMIZE_TEXTFIELD])) {
                            foreach ($customization['datas'][Product::CUSTOMIZE_TEXTFIELD] as $text) {
                                $customization_text .= '<strong>' . $text['name'] . '</strong>: ' . $text['value'] . '<br />';
                            }
                        }

                        if (isset($customization['datas'][Product::CUSTOMIZE_FILE])) {
                            $customization_text .= $this->trans('%d image(s)', array(count($customization['datas'][Product::CUSTOMIZE_FILE])), 'Admin.Payment.Notification') . '<br />';
                        }

                        $customization_quantity = (int) $customization['quantity'];

                        $product_var_tpl['customization'][] = array(
                            'customization_text' => $customization_text,
                            'customization_quantity' => $customization_quantity,
                            'quantity' => Tools::displayPrice($customization_quantity * $product_price, $this->context->currency, false),
                         );
                    }
                }

                $product_var_tpl_list[] = $product_var_tpl;
                // Check if is not a virutal product for the displaying of shipping
                if (!$product['is_virtual']) {
                    $virtual_product &= false;
                }
            } // end foreach ($products)
            $product_list_txt = '';
            $product_list_html = '';
            if (count($product_var_tpl_list) > 0) {
                $product_list_txt = $this->getEmailTemplateContent('order_conf_product_list.txt', Mail::TYPE_TEXT, $product_var_tpl_list);
                $product_list_html = $this->getEmailTemplateContent('order_conf_product_list.tpl', Mail::TYPE_HTML, $product_var_tpl_list);
            }

            $cart_rules_list = array();
            $cart_rules = $order->getCartRules();
            $total_reduction_value_ti = 0;
            $total_reduction_value_tex = 0;
            foreach ($cart_rules as $cart_rule) {
                PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] sendEmailToUser - cart_rule:[ " . json_encode($cart_rule) . '] $email_subject: [' . $email_subject . ']' . date("d/m/y H:i:s"));

                $values = array(
                    'tax_incl' => $cart_rule['value'],
                    'tax_excl' => $cart_rule['value_tax_excl'],
                );

                // If the reduction is not applicable to this order, then continue with the next one
                if (!$values['tax_excl']) {
                    continue;
                }

                $cart_rules_list[] = array(
                    'voucher_name' => $cart_rule['name'],
                    'voucher_reduction' => ($values['tax_incl'] != 0.00 ? '-' : '') . Tools::displayPrice($values['tax_incl'], $this->context->currency, false),
                );
            }

            $cart_rules_list_txt = '';
            $cart_rules_list_html = '';
            if (count($cart_rules_list) > 0) {
                $cart_rules_list_txt = $this->getEmailTemplateContent('order_conf_cart_rules.txt', Mail::TYPE_TEXT, $cart_rules_list);
                $cart_rules_list_html = $this->getEmailTemplateContent('order_conf_cart_rules.tpl', Mail::TYPE_HTML, $cart_rules_list);
            }
            $email_template_vars = array(
                '{firstname}' => $customer->firstname,
                '{lastname}' => $customer->lastname,
                '{email}' => $customer->email,
                '{delivery_block_txt}' => $this->getFormatedAddress($delivery, "\n"),
                '{invoice_block_txt}' => $this->getFormatedAddress($invoice, "\n"),
                '{delivery_block_html}' => $this->getFormatedAddress($delivery, '<br />', array(
                    'firstname'	=> '<span style="font-weight:bold;">%s</span>',
                    'lastname'	=> '<span style="font-weight:bold;">%s</span>'
                )),
                '{invoice_block_html}' => $this->getFormatedAddress($invoice, '<br />', array(
                    'firstname'	=> '<span style="font-weight:bold;">%s</span>',
                    'lastname'	=> '<span style="font-weight:bold;">%s</span>'
                )),
                '{order_name}' => $order->getUniqReference(),
                '{date}' => Tools::displayDate(date('Y-m-d H:i:s'), intval($order->id_lang), 1),
				'{carrier}' => (strval($carrier->name) != '0' ? $carrier->name : Configuration::get('PS_SHOP_NAME')),
                '{products}' => $product_list_html,
                '{products_txt}' => $product_list_txt,
                '{discounts}' => $cart_rules_list_html,
                '{discounts_txt}' => $cart_rules_list_txt,
                '{delivery_company}' => $delivery->company,
				'{delivery_firstname}' => $delivery->firstname,
				'{delivery_lastname}' => $delivery->lastname,
				'{delivery_address1}' => $delivery->address1,
				'{delivery_address2}' => $delivery->address2,
				'{delivery_city}' => $delivery->city,
				'{delivery_postal_code}' => $delivery->postcode,
				'{delivery_country}' => $delivery->country,
				'{delivery_state}' => $delivery->id_state ? $delivery_state->name : '',
				'{delivery_phone}' => $delivery->phone,
				'{delivery_other}' => $delivery->other,
				'{invoice_company}' => $invoice->company,
				'{invoice_firstname}' => $invoice->firstname,
				'{invoice_lastname}' => $invoice->lastname,
				'{invoice_address2}' => $invoice->address2,
				'{invoice_address1}' => $invoice->address1,
				'{invoice_city}' => $invoice->city,
				'{invoice_postal_code}' => $invoice->postcode,
				'{invoice_country}' => $invoice->country,
				'{invoice_state}' => $invoice->id_state ? $invoice_state->name : '',
				'{invoice_phone}' => $invoice->phone,
				'{invoice_other}' => $invoice->other,
                '{total_paid}' => Tools::displayPrice($order->total_paid, $this->context->currency, false),
                '{total_products}' => Tools::displayPrice(Product::getTaxCalculationMethod() == PS_TAX_EXC ? $order->total_products : $order->total_products_wt, $this->context->currency, false),
                '{total_discounts}' => Tools::displayPrice($order->total_discounts, $this->context->currency, false),
                '{total_shipping}' => Tools::displayPrice($order->total_shipping, $this->context->currency, false),
                '{total_wrapping}' => Tools::displayPrice($order->total_wrapping, $this->context->currency, false),
                '{total_tax_paid}' => Tools::displayPrice(($order->total_products_wt - $order->total_products) + ($order->total_shipping_tax_incl - $order->total_shipping_tax_excl), $this->context->currency, false),
                '{payment}' => $order->payment,
            );
            PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] sendEmailToUser - orderId:[ " . $orderId . '] $email_subject: [' . $email_subject . ']' . date("d/m/y H:i:s"));

            // Send email
            Mail::Send(
                (int)$order->id_lang,
                $email_template,
                $email_subject,
                $email_template_vars,
                $customer->email,
                trim($customer->firstname . ' ' . $customer->lastname),
                null,
                null,
                null,
                null,
                _PS_MAIL_DIR_,
                false,
                (int)$order->id_shop
            );

            
        } catch (Exception $ex) {
            PrestaShopLogger::addLog("[instantcreditValidationModuleFrontController] sendEmailToUser Excepcion Global: [ " . $ex->getMessage() . '] Linea:[' . $ex->getLine() . '] ' . date("d/m/y H:i:s"));
        }

    }

}
